<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'Order';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'payable_total', 'receiver_name', 'receiver_address', 'status');

    public function orderDetails()
    {
        return $this->hasOne('App\Models\Order_detail', 'order_id');
    }

    public function orderUser()
    {
        return $this->hasOne('App\Models\User', 'user_id');
    }

    public function orderTransaction()
    {
        return $this->hasOne('App\Models\Payment', 'order_id');
    }

}